﻿//  Render, Increment Save and Shutdown v1.0
//  based on Lloyd Alvarez's Render, Email, Increment Save and Shutdown v1.02
//  July 2008
//  All credit to Lloyd Alvarez  lloyd@aescripts.com; 
//  Email Routine removed by Chris Kelley chris@chriskelley.tv
//

//version history
//
//1.1 made CS5 compatible - May 2010
//1.0  slight adjustment from Lloyd Alvarez's script, only removed Email routine.

{
/////////////////////////USER VARIABLES///////////////////////////////////
// Apparently different flavors of windows have different ways of issuing the shutdown command
// If your machine is not shutting down after the render is finished you might need to research 
// what the correct command to shutdown your machine is.  You can refer to this webpage for more 
// info: http://www.aumha.org/win5/a/shutcut.php
// That webpage also points to a freeware utility that apparently will shutdown any windows machine.
// You can download that utility here: http://www.aumha.org/downloads/shutdown.zip
// If you install that utility, you will need to change the windowsShutdownCommand below 
// to be this: "shutdown -u -t 30"


var windowsShutdownCommand = "SHUTDOWN -s -t 30";

//
//
//  On Mac you can choose: shut down or sleep.  Change the text below to whichever you prefer.
//  Make sure it's lower case and in the case of shut down to put a space between shut and down.
//
//
var macOnlyShutdownCommand = "shut down";  
//														
//
///////////////////////////////////////////////////////////////////////////
	
function isSecurityPrefSet(){
		var securitySetting = app.preferences.getPrefAsLong("Main Pref Section",
						"Pref_SCRIPTING_FILE_NETWORK_SECURITY");
		return (securitySetting == 1);
	}


function saveAndIncrement() {

if (!app.project.file) {
	alert ("This project must be saved before running this script.");
} else {
	var currFile = app.project.file;
	var currFileName = currFile.name;
	var extPos = currFileName.lastIndexOf(".");
	var ext = "";
	
	if (extPos != -1) {
		ext = currFileName.substring(extPos, currFileName.length);
		currFileName = currFileName.substring(0, extPos);
	}
	
	var incrementer = 0;
	if (currFileName.charAt(currFileName.length -4) == "_") {
		//Assume the incrementer has run before if underscore is the fourth character from the end.
		//This is the case for files with 3 digit extensions.
		incrementer = currFileName.substring(currFileName.length - 3, currFileName.length);
		currFileName = currFileName.substring(0, currFileName.length -4);
	}
	
	incrementer++;
	var istring = incrementer + "";
	if( (incrementer / 10) < 1.0) {
		istring = "0" + istring;
	}
	if( (incrementer / 100) < 1.0) {
		istring = "0" + istring;
	}
	
	var newFile = File(currFile.path + "/" + currFileName + "_" + istring + ext);
	//alert(newFile.fsName);
	app.project.save(newFile);
}

} // CLOSE SAVE & INCREMENT FUNCTION


	var safeToRunScript = true;
	
	safeToRunScript = app.project != null;
	if (!app.project.file) {
	alert ("This project must be saved before running this script.");
	safeToRunScript = false;
	}
	
	if (safeToRunScript) {
		//check the render queue and make certain at least one item is queued
		safeToRunScript = false;
		for (i = 1; i <= app.project.renderQueue.numItems; ++i) {
			if (app.project.renderQueue.item(i).status == RQItemStatus.QUEUED) {
				safeToRunScript = true;
				break;
			}
		}
		if (! safeToRunScript) {
			alert ("You do not have any items set to render.");
		}
		if (!isSecurityPrefSet()) {
	
	var prefWarning = "This script requires the scripting security preference to be set.\n" +
		"Go to the \"General\" panel of the application preferences and make sure " + 
         "\"Allow Scripts to Write Files and Access Network\" is checked.";	
		 
		alert(prefWarning);
	safeToRunScript = false;
	}
	}
	
	if (safeToRunScript) {
		
	
		var myQueue = app.project.renderQueue //creates a shortcut for RQ
		
		// Call render
		myQueue.render();
			
		// Now rendering is complete.
		
		saveAndIncrement();
		
		
	if ($.os.indexOf("Windows") == -1){
	var restartCommand = "arch -i386 osascript -e 'tell application \"System Events\" to " + macOnlyShutdownCommand + "'";
	 system.callSystem(restartCommand);
	 } else {
		 system.callSystem("cmd /c \""+windowsShutdownCommand+"\""); 
		 }
	}


} // CLOSE MAIN {
	
	
	
	
	
	